/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.combat;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import net.minecraft.class_2828;
import net.minecraft.class_3532;

@ModuleInfo(name="TP Aura", category=ModuleCategory.COMBAT, desc="modules.descriptions.tp_aura")
public class TPInfluence
extends BaseModule {
    private BooleanSetting spawnAbove;
    private class_1657 currentTarget = null;
    private class_243 originalPosition = null;
    private final List<TimedRunnable> postDoingRuns = new ArrayList<TimedRunnable>();
    private long lastTpTime = 0L;
    private boolean isProcessing = false;
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        if (TPInfluence.mc.field_1724 == null || TPInfluence.mc.field_1687 == null) {
            return;
        }
        this.updatePostActionsRuns(false);
        if (this.isProcessing) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTpTime < 1000L) {
            return;
        }
        class_1657 newTarget = this.findTarget();
        if (newTarget != null) {
            this.currentTarget = newTarget;
            this.performTeleport();
        }
    };

    public TPInfluence() {
        this.spawnAbove = new BooleanSetting(this, "Spawn Above");
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.currentTarget = null;
        this.postDoingRuns.clear();
        this.lastTpTime = 0L;
        this.isProcessing = false;
        if (TPInfluence.mc.field_1724 != null) {
            this.originalPosition = TPInfluence.mc.field_1724.method_19538();
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.updatePostActionsRuns(true);
        this.currentTarget = null;
        this.originalPosition = null;
        this.lastTpTime = 0L;
        this.isProcessing = false;
    }

    private void performTeleport() {
        if (this.currentTarget == null || TPInfluence.mc.field_1724 == null) {
            return;
        }
        double distance = TPInfluence.mc.field_1724.method_5739((class_1297)this.currentTarget);
        if (distance > 50.0) {
            return;
        }
        this.isProcessing = true;
        class_243 targetPos = this.calculateTargetPosition(this.currentTarget);
        this.executeTeleport(TPInfluence.mc.field_1724.method_19538(), targetPos);
        this.lastTpTime = System.currentTimeMillis();
    }

    private void executeTeleport(class_243 from, class_243 to) {
        double dx = Math.abs(from.field_1352 - to.field_1352);
        double dy = Math.abs(from.field_1351 - to.field_1351);
        double dz = Math.abs(from.field_1350 - to.field_1350);
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float distanceDensity = 1.0f;
        int packetCount = (int)(distance / (9.64 * (double)distanceDensity)) + 1;
        for (int i = 0; i < packetCount; ++i) {
            this.sendGroundPacket(false);
        }
        this.sendPositionPacket(to.field_1352, to.field_1351, to.field_1350, false);
        TPInfluence.mc.field_1724.method_33574(to);
        if (this.currentTarget != null) {
            class_1657 targetCopy = this.currentTarget;
            int attackDelay = this.spawnAbove.isEnabled() ? 5 : 3;
            this.teleportActionDoingPost(() -> {
                this.tpAura(targetCopy);
                if (this.originalPosition != null) {
                    class_243 returnPos = this.originalPosition;
                    double currentY = TPInfluence.mc.field_1724.method_23318();
                    double verticalDist = Math.abs(currentY - returnPos.field_1351);
                    int returnDelay = 8;
                    if (verticalDist > 15.0) {
                        returnDelay = 15;
                    } else if (verticalDist > 10.0) {
                        returnDelay = 12;
                    } else if (verticalDist > 5.0) {
                        returnDelay = 10;
                    } else if (verticalDist > 2.0) {
                        returnDelay = 9;
                    }
                    this.teleportActionDoingPost(() -> {
                        this.executeTeleportBack(TPInfluence.mc.field_1724.method_19538(), returnPos);
                        this.teleportActionDoingPost(() -> {
                            this.isProcessing = false;
                        }, 2);
                    }, returnDelay);
                }
            }, attackDelay);
        }
    }

    private void executeTeleportBack(class_243 from, class_243 to) {
        double dx = Math.abs(from.field_1352 - to.field_1352);
        double dy = Math.abs(from.field_1351 - to.field_1351);
        double dz = Math.abs(from.field_1350 - to.field_1350);
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float distanceDensity = 1.0f;
        int packetCount = (int)(distance / (9.64 * (double)distanceDensity)) + 1;
        for (int i = 0; i < packetCount; ++i) {
            this.sendGroundPacket(false);
        }
        this.sendPositionPacket(to.field_1352, to.field_1351, to.field_1350, false);
        TPInfluence.mc.field_1724.method_33574(to);
    }

    private void tpAura(class_1657 target) {
        if (target == null || TPInfluence.mc.field_1724 == null || !target.method_5805()) {
            return;
        }
        double distance = TPInfluence.mc.field_1724.method_5739((class_1297)target);
        if (distance > 6.0) {
            return;
        }
        this.lookAtEntity(target);
        TPInfluence.mc.field_1724.field_3944.method_52787((class_2596)class_2824.method_34206((class_1297)target, (boolean)TPInfluence.mc.field_1724.method_5715()));
        TPInfluence.mc.field_1724.method_6104(class_1268.field_5808);
    }

    private void lookAtEntity(class_1657 entity) {
        if (entity == null || TPInfluence.mc.field_1724 == null) {
            return;
        }
        class_243 targetPos = entity.method_19538().method_1031(0.0, (double)entity.method_18381(entity.method_18376()) * 0.9, 0.0);
        class_243 playerPos = TPInfluence.mc.field_1724.method_19538().method_1031(0.0, (double)TPInfluence.mc.field_1724.method_18381(TPInfluence.mc.field_1724.method_18376()), 0.0);
        double deltaX = targetPos.field_1352 - playerPos.field_1352;
        double deltaY = targetPos.field_1351 - playerPos.field_1351;
        double deltaZ = targetPos.field_1350 - playerPos.field_1350;
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(deltaY, distance) * 180.0 / Math.PI));
        TPInfluence.mc.field_1724.method_36456(yaw);
        TPInfluence.mc.field_1724.method_36457(pitch);
    }

    private class_243 calculateTargetPosition(class_1657 target) {
        class_243 targetPos = target.method_19538();
        class_243 direction = targetPos.method_1020(TPInfluence.mc.field_1724.method_19538()).method_1029();
        double offset = 2.0;
        class_243 teleportPos = targetPos.method_1020(direction.method_1021(offset));
        teleportPos = this.spawnAbove.isEnabled() ? teleportPos.method_1031(0.0, 1.5, 0.0) : teleportPos.method_1031(0.0, 0.5, 0.0);
        class_2338 groundPos = this.findNearestSolidBlock(teleportPos, 5.0);
        if (groundPos != null && !this.spawnAbove.isEnabled()) {
            teleportPos = new class_243(teleportPos.field_1352, (double)groundPos.method_10264() + 0.65, teleportPos.field_1350);
        }
        return teleportPos;
    }

    private class_2338 findNearestSolidBlock(class_243 pos, double radius) {
        class_2338 center = class_2338.method_49638((class_2374)pos);
        int y = 0;
        while ((double)y < radius) {
            class_2338 checkPos = center.method_10087(y);
            if (TPInfluence.mc.field_1687.method_8320(checkPos).method_51367()) {
                return checkPos;
            }
            ++y;
        }
        return null;
    }

    private class_1657 findTarget() {
        if (TPInfluence.mc.field_1687 == null || TPInfluence.mc.field_1724 == null) {
            return null;
        }
        class_1657 closest = null;
        float closestDist = Float.MAX_VALUE;
        for (class_1657 player : TPInfluence.mc.field_1687.method_18456()) {
            float dist;
            if (player == TPInfluence.mc.field_1724 || !player.method_5805() || player.method_7325() || player.method_7337() || !((double)(dist = TPInfluence.mc.field_1724.method_5739((class_1297)player)) <= 50.0) || !(dist < closestDist)) continue;
            closest = player;
            closestDist = dist;
        }
        return closest;
    }

    private void sendPositionPacket(double x, double y, double z, boolean onGround) {
        TPInfluence.mc.field_1724.field_3944.method_52787((class_2596)new class_2828.class_2829(x, y, z, onGround, TPInfluence.mc.field_1724.field_5976));
    }

    private void sendGroundPacket(boolean onGround) {
        TPInfluence.mc.field_1724.field_3944.method_52787((class_2596)new class_2828.class_5911(onGround, TPInfluence.mc.field_1724.field_5976));
    }

    private void updatePostActionsRuns(boolean clear) {
        if (clear) {
            this.postDoingRuns.clear();
        } else if (!this.postDoingRuns.isEmpty()) {
            this.postDoingRuns.removeIf(TimedRunnable::doIfRemove);
        }
    }

    private void teleportActionDoingPost(Runnable run, int ticksAfter) {
        this.postDoingRuns.add(new TimedRunnable(run, (float)ticksAfter * 50.0f - 5.0f));
    }

    public String getDisplayInfo() {
        if (this.currentTarget != null) {
            return this.currentTarget.method_5477().getString();
        }
        return null;
    }

    private static class TimedRunnable {
        private final long startTime = System.currentTimeMillis();
        private final float maxTime;
        private Runnable runnable;

        public TimedRunnable(Runnable runnable, float maxTime) {
            this.runnable = runnable;
            this.maxTime = maxTime;
        }

        private float getTimePC() {
            return class_3532.method_15363((float)((float)(System.currentTimeMillis() - this.startTime) / this.maxTime), (float)0.0f, (float)1.0f);
        }

        public boolean doIfRemove() {
            if (this.getTimePC() >= 1.0f && this.runnable != null) {
                this.runnable.run();
                this.runnable = null;
                return true;
            }
            return this.runnable == null;
        }
    }
}

